# Hummingbird Python Library

A Python interface for controlling Hummingbird laser devices over a serial connection.

## Features

- **Simple API**: Direct methods for common laser operations (`on`, `off`, `status`, `clear`).
- **Context Manager Support**: Safely handle serial connections using the `with` statement.
- **Built-in CLI**: Control your device directly from the terminal.
- **JSON Parsing**: Automatic parsing of device status and responses into Python dictionaries.

## Installation

### Requirements

- Python 3.x
- `pyserial` library

### Setup

```bash
pip install pyserial
```

## Library Usage

The library provides a `Hummingbird` class to interface with the device.

```python
from hummingbird import Hummingbird

# Connect to the device
hb = Hummingbird("/dev/ttyACM0")

# Get device status
status = hb.status()
print(f"Current State: {status['state']}")

# Clear error state if any
hb.clear()

# Turn laser on
hb.on()

# Turn laser off
hb.off()
```

> [!NOTE]
> For a more comprehensive example including error checking and wait loops, see _example.py_.

## CLI Usage

`hummingbird.py` can be used as a standalone command-line tool.

**Format:**
```bash
python hummingbird.py <port> <command>
```

**Common Commands:**
- `on`: Turn the laser on.
- `off`: Turn the laser off.
- `status?`: Get device status (returns JSON).
- `on?`: Check if laser is on.
- `off?`: Check if laser is off.
- `clear`: Clear the error state.

**Examples:**
```bash
# Get status
python hummingbird.py /dev/ttyACM0 status?

# Turn laser on
python hummingbird.py /dev/ttyACM0 on
```

## Running Tests

Unit tests are provided in `test_hummingbird.py`.

```bash
python test_hummingbird.py
```

## License

This project is licensed under the terms of the MIT license.
